/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;

public class jfr2flame {
    private static final String[] FRAME_SUFFIX = new String[]{"_[j]", "_[j]", "_[i]", "", "", "_[k]"};
    private final JfrReader jfr;
    private final Dictionary<String> methodNames = new Dictionary();

    public jfr2flame(JfrReader jfrReader) {
        this.jfr = jfrReader;
    }

    public void convert(final FlameGraph flameGraph, final boolean bl, boolean bl2, final boolean bl3, final boolean bl4, Class<? extends Event> clazz) throws IOException {
        Event event;
        EventAggregator eventAggregator = new EventAggregator(bl, bl2);
        while ((event = this.jfr.readEvent(clazz)) != null) {
            eventAggregator.collect(event);
        }
        final double d = 1.0E9 / (double)this.jfr.ticksPerSec;
        final boolean bl5 = bl2 && clazz == ContendedLock.class && d != 1.0;
        eventAggregator.forEach(new EventAggregator.Visitor(){

            @Override
            public void visit(Event event, long l) {
                StackTrace stackTrace = ((jfr2flame)jfr2flame.this).jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    long[] lArray = stackTrace.methods;
                    byte[] byArray = stackTrace.types;
                    int[] nArray = stackTrace.locations;
                    String string = jfr2flame.this.getClassFrame(event);
                    String[] stringArray = new String[lArray.length + (bl ? 1 : 0) + (string != null ? 1 : 0)];
                    if (bl) {
                        stringArray[0] = jfr2flame.this.getThreadFrame(event.tid);
                    }
                    int n = stringArray.length;
                    if (string != null) {
                        stringArray[--n] = string;
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        int n2;
                        String string2 = jfr2flame.this.getMethodName(lArray[i]);
                        if (bl3 && (n2 = nArray[i] >>> 16) != 0) {
                            string2 = string2 + ":" + n2;
                        } else if (bl4 && (n2 = nArray[i] & 0xFFFF) != 0) {
                            string2 = string2 + "@" + n2;
                        }
                        stringArray[--n] = string2 + FRAME_SUFFIX[byArray[i]];
                    }
                    flameGraph.addSample(stringArray, bl5 ? (long)((double)l * d) : l);
                }
            }
        });
    }

    private String getThreadFrame(int n) {
        String string = this.jfr.threads.get(n);
        return string == null ? "[tid=" + n + ']' : '[' + string + " tid=" + n + ']';
    }

    private String getClassFrame(Event event) {
        String string;
        long l;
        if (event instanceof AllocationSample) {
            l = ((AllocationSample)event).classId;
            string = ((AllocationSample)event).tlabSize == 0L ? "_[k]" : "_[i]";
        } else if (event instanceof ContendedLock) {
            l = ((ContendedLock)event).classId;
            string = "_[i]";
        } else {
            return null;
        }
        ClassRef classRef = this.jfr.classes.get(l);
        if (classRef == null) {
            return "null";
        }
        byte[] byArray = this.jfr.symbols.get(classRef.name);
        int n = 0;
        while (byArray[n] == 91) {
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder(this.toJavaClassName(byArray, n));
        while (n-- > 0) {
            stringBuilder.append("[]");
        }
        return stringBuilder.append(string).toString();
    }

    private String toJavaClassName(byte[] byArray, int n) {
        switch (byArray[n]) {
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 90: {
                return "boolean";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 76: {
                return new String(byArray, n + 1, byArray.length - n - 2, StandardCharsets.UTF_8).replace('/', '.');
            }
        }
        return new String(byArray, n, byArray.length - n, StandardCharsets.UTF_8).replace('/', '.');
    }

    private String getMethodName(long l) {
        String string = this.methodNames.get(l);
        if (string != null) {
            return string;
        }
        MethodRef methodRef = this.jfr.methods.get(l);
        if (methodRef == null) {
            string = "unknown";
        } else {
            ClassRef classRef = this.jfr.classes.get(methodRef.cls);
            byte[] byArray = this.jfr.symbols.get(classRef.name);
            byte[] byArray2 = this.jfr.symbols.get(methodRef.name);
            if (byArray == null || byArray.length == 0) {
                string = new String(byArray2, StandardCharsets.UTF_8);
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = new String(byArray2, StandardCharsets.UTF_8);
                string = string2 + '.' + string3;
            }
        }
        this.methodNames.put(l, string);
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        FlameGraph flameGraph = new FlameGraph(stringArray);
        if (flameGraph.input == null) {
            System.out.println("Usage: java " + jfr2flame.class.getName() + " [options] input.jfr [output.html]");
            System.out.println();
            System.out.println("options include all supported FlameGraph options, plus the following:");
            System.out.println("  --alloc    Allocation Flame Graph");
            System.out.println("  --lock     Lock contention Flame Graph");
            System.out.println("  --threads  Split profile by threads");
            System.out.println("  --total    Accumulate the total value (time, bytes, etc.)");
            System.out.println("  --lines    Show line numbers");
            System.out.println("  --bci      Show bytecode indices");
            System.exit(1);
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        boolean bl = hashSet.contains("--threads");
        boolean bl2 = hashSet.contains("--total");
        boolean bl3 = hashSet.contains("--lines");
        boolean bl4 = hashSet.contains("--bci");
        Class clazz = hashSet.contains("--alloc") ? AllocationSample.class : (hashSet.contains("--lock") ? ContendedLock.class : ExecutionSample.class);
        try (JfrReader jfrReader = new JfrReader(flameGraph.input);){
            new jfr2flame(jfrReader).convert(flameGraph, bl, bl2, bl3, bl4, clazz);
        }
        flameGraph.dump();
    }
}

