/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.Element;
import one.jfr.JfrClass;
import one.jfr.JfrField;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.ExecutionSample;

public class JfrReader
implements Closeable {
    private static final int BUFFER_SIZE = 0x200000;
    private static final int CHUNK_HEADER_SIZE = 68;
    private static final int CHUNK_SIGNATURE = 1179406848;
    private final FileChannel ch;
    private ByteBuffer buf;
    private long filePosition;
    public boolean incomplete;
    public long startNanos = Long.MAX_VALUE;
    public long endNanos = Long.MIN_VALUE;
    public long startTicks = Long.MAX_VALUE;
    public long ticksPerSec;
    public final Dictionary<JfrClass> types = new Dictionary();
    public final Map<String, JfrClass> typesByName = new HashMap<String, JfrClass>();
    public final Dictionary<String> threads = new Dictionary();
    public final Dictionary<ClassRef> classes = new Dictionary();
    public final Dictionary<byte[]> symbols = new Dictionary();
    public final Dictionary<MethodRef> methods = new Dictionary();
    public final Dictionary<StackTrace> stackTraces = new Dictionary();
    public final Map<Integer, String> frameTypes = new HashMap<Integer, String>();
    public final Map<Integer, String> threadStates = new HashMap<Integer, String>();
    private int executionSample;
    private int nativeMethodSample;
    private int allocationInNewTLAB;
    private int allocationOutsideTLAB;
    private int allocationSample;
    private int monitorEnter;
    private int threadPark;

    public JfrReader(String string) throws IOException {
        this.ch = FileChannel.open(Paths.get(string, new String[0]), StandardOpenOption.READ);
        this.buf = ByteBuffer.allocateDirect(0x200000);
        this.buf.flip();
        this.ensureBytes(68);
        if (!this.readChunk(0)) {
            throw new IOException("Incomplete JFR file");
        }
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    public long durationNanos() {
        return this.endNanos - this.startNanos;
    }

    public List<Event> readAllEvents() throws IOException {
        return this.readAllEvents(null);
    }

    public <E extends Event> List<E> readAllEvents(Class<E> clazz) throws IOException {
        E e;
        ArrayList<E> arrayList = new ArrayList<E>();
        while ((e = this.readEvent(clazz)) != null) {
            arrayList.add(e);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Event readEvent() throws IOException {
        return this.readEvent(null);
    }

    public <E extends Event> E readEvent(Class<E> clazz) throws IOException {
        while (this.ensureBytes(68)) {
            int n = this.buf.position();
            int n2 = this.getVarint();
            int n3 = this.getVarint();
            if (n3 == 76 && this.buf.getInt(n) == 1179406848) {
                if (!this.readChunk(n)) break;
                continue;
            }
            if (n3 == this.executionSample || n3 == this.nativeMethodSample) {
                if (clazz == null || clazz == ExecutionSample.class) {
                    return (E)this.readExecutionSample();
                }
            } else if (n3 == this.allocationInNewTLAB) {
                if (clazz == null || clazz == AllocationSample.class) {
                    return (E)this.readAllocationSample(true);
                }
            } else if (n3 == this.allocationOutsideTLAB || n3 == this.allocationSample) {
                if (clazz == null || clazz == AllocationSample.class) {
                    return (E)this.readAllocationSample(false);
                }
            } else if (n3 == this.monitorEnter) {
                if (clazz == null || clazz == ContendedLock.class) {
                    return (E)this.readContendedLock(false);
                }
            } else if (n3 == this.threadPark && (clazz == null || clazz == ContendedLock.class)) {
                return (E)this.readContendedLock(true);
            }
            if ((n += n2) <= this.buf.limit()) {
                this.buf.position(n);
                continue;
            }
            this.seek(this.filePosition + (long)n);
        }
        return null;
    }

    private ExecutionSample readExecutionSample() {
        long l = this.getVarlong();
        int n = this.getVarint();
        int n2 = this.getVarint();
        int n3 = this.getVarint();
        return new ExecutionSample(l, n, n2, n3);
    }

    private AllocationSample readAllocationSample(boolean bl) {
        long l = this.getVarlong();
        int n = this.getVarint();
        int n2 = this.getVarint();
        int n3 = this.getVarint();
        long l2 = this.getVarlong();
        long l3 = bl ? this.getVarlong() : 0L;
        return new AllocationSample(l, n, n2, n3, l2, l3);
    }

    private ContendedLock readContendedLock(boolean bl) {
        long l = this.getVarlong();
        long l2 = this.getVarlong();
        int n = this.getVarint();
        int n2 = this.getVarint();
        int n3 = this.getVarint();
        if (bl) {
            this.getVarlong();
        }
        long l3 = this.getVarlong();
        long l4 = this.getVarlong();
        return new ContendedLock(l, n, n2, l2, n3);
    }

    private boolean readChunk(int n) throws IOException {
        if (n + 68 > this.buf.limit() || this.buf.getInt(n) != 1179406848) {
            throw new IOException("Not a valid JFR file");
        }
        int n2 = this.buf.getInt(n + 4);
        if (n2 < 131072 || n2 > 196607) {
            throw new IOException("Unsupported JFR version: " + (n2 >>> 16) + "." + (n2 & 0xFFFF));
        }
        long l = this.buf.getLong(n + 16);
        long l2 = this.buf.getLong(n + 24);
        if (l == 0L || l2 == 0L) {
            this.incomplete = true;
            return false;
        }
        this.startNanos = Math.min(this.startNanos, this.buf.getLong(n + 32));
        this.endNanos = Math.max(this.endNanos, this.buf.getLong(n + 32) + this.buf.getLong(n + 40));
        this.startTicks = Math.min(this.startTicks, this.buf.getLong(n + 48));
        this.ticksPerSec = this.buf.getLong(n + 56);
        this.types.clear();
        this.typesByName.clear();
        long l3 = this.filePosition + (long)n;
        this.readMeta(l3 + l2);
        this.readConstantPool(l3 + l);
        this.cacheEventTypes();
        this.seek(l3 + 68L);
        return true;
    }

    private void readMeta(long l) throws IOException {
        this.seek(l);
        this.ensureBytes(5);
        this.ensureBytes(this.getVarint() - this.buf.position());
        this.getVarint();
        this.getVarlong();
        this.getVarlong();
        this.getVarlong();
        String[] stringArray = new String[this.getVarint()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getString();
        }
        this.readElement(stringArray);
    }

    private Element readElement(String[] stringArray) {
        String string = stringArray[this.getVarint()];
        int n = this.getVarint();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[this.getVarint()], stringArray[this.getVarint()]);
        }
        Element element = this.createElement(string, hashMap);
        int n2 = this.getVarint();
        for (int i = 0; i < n2; ++i) {
            element.addChild(this.readElement(stringArray));
        }
        return element;
    }

    private Element createElement(String string, Map<String, String> map) {
        switch (string) {
            case "class": {
                JfrClass jfrClass = new JfrClass(map);
                if (!map.containsKey("superType")) {
                    this.types.put(jfrClass.id, jfrClass);
                }
                this.typesByName.put(jfrClass.name, jfrClass);
                return jfrClass;
            }
            case "field": {
                return new JfrField(map);
            }
        }
        return new Element();
    }

    private void readConstantPool(long l) throws IOException {
        long l2;
        do {
            this.seek(l);
            this.ensureBytes(5);
            this.ensureBytes(this.getVarint() - this.buf.position());
            this.getVarint();
            this.getVarlong();
            this.getVarlong();
            l2 = this.getVarlong();
            this.getVarint();
            int n = this.getVarint();
            for (int i = 0; i < n; ++i) {
                int n2 = this.getVarint();
                this.readConstants(this.types.get(n2));
            }
        } while (l2 != 0L && (l += l2) > 0L);
    }

    private void readConstants(JfrClass jfrClass) {
        switch (jfrClass.name) {
            case "jdk.types.ChunkHeader": {
                this.buf.position(this.buf.position() + 71);
                break;
            }
            case "java.lang.Thread": {
                this.readThreads(jfrClass.field("group") != null);
                break;
            }
            case "java.lang.Class": {
                this.readClasses(jfrClass.field("hidden") != null);
                break;
            }
            case "jdk.types.Symbol": {
                this.readSymbols();
                break;
            }
            case "jdk.types.Method": {
                this.readMethods();
                break;
            }
            case "jdk.types.StackTrace": {
                this.readStackTraces();
                break;
            }
            case "jdk.types.FrameType": {
                this.readMap(this.frameTypes);
                break;
            }
            case "jdk.types.ThreadState": {
                this.readMap(this.threadStates);
                break;
            }
            default: {
                this.readOtherConstants(jfrClass.fields);
            }
        }
    }

    private void readThreads(boolean bl) {
        int n = this.threads.preallocate(this.getVarint());
        for (int i = 0; i < n; ++i) {
            long l = this.getVarlong();
            String string = this.getString();
            int n2 = this.getVarint();
            String string2 = this.getString();
            long l2 = this.getVarlong();
            if (bl) {
                this.getVarlong();
            }
            this.threads.put(l, string2 != null ? string2 : string);
        }
    }

    private void readClasses(boolean bl) {
        int n = this.classes.preallocate(this.getVarint());
        for (int i = 0; i < n; ++i) {
            long l = this.getVarlong();
            long l2 = this.getVarlong();
            long l3 = this.getVarlong();
            long l4 = this.getVarlong();
            int n2 = this.getVarint();
            if (bl) {
                this.getVarint();
            }
            this.classes.put(l, new ClassRef(l3));
        }
    }

    private void readMethods() {
        int n = this.methods.preallocate(this.getVarint());
        for (int i = 0; i < n; ++i) {
            long l = this.getVarlong();
            long l2 = this.getVarlong();
            long l3 = this.getVarlong();
            long l4 = this.getVarlong();
            int n2 = this.getVarint();
            int n3 = this.getVarint();
            this.methods.put(l, new MethodRef(l2, l3, l4));
        }
    }

    private void readStackTraces() {
        int n = this.stackTraces.preallocate(this.getVarint());
        for (int i = 0; i < n; ++i) {
            long l = this.getVarlong();
            int n2 = this.getVarint();
            StackTrace stackTrace = this.readStackTrace();
            this.stackTraces.put(l, stackTrace);
        }
    }

    private StackTrace readStackTrace() {
        int n = this.getVarint();
        long[] lArray = new long[n];
        byte[] byArray = new byte[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getVarlong();
            int n2 = this.getVarint();
            int n3 = this.getVarint();
            nArray[i] = n2 << 16 | n3 & 0xFFFF;
            byArray[i] = this.buf.get();
        }
        return new StackTrace(lArray, byArray, nArray);
    }

    private void readSymbols() {
        int n = this.symbols.preallocate(this.getVarint());
        for (int i = 0; i < n; ++i) {
            long l = this.getVarlong();
            if (this.buf.get() != 3) {
                throw new IllegalArgumentException("Invalid symbol encoding");
            }
            this.symbols.put(l, this.getBytes());
        }
    }

    private void readMap(Map<Integer, String> map) {
        int n = this.getVarint();
        for (int i = 0; i < n; ++i) {
            map.put(this.getVarint(), this.getString());
        }
    }

    private void readOtherConstants(List<JfrField> list) {
        int n;
        int n2 = this.getTypeId("java.lang.String");
        boolean[] blArray = new boolean[list.size()];
        for (n = 0; n < blArray.length; ++n) {
            JfrField jfrField = list.get(n);
            blArray[n] = jfrField.constantPool || jfrField.type != n2;
        }
        n = this.getVarint();
        for (int i = 0; i < n; ++i) {
            this.getVarlong();
            this.readFields(blArray);
        }
    }

    private void readFields(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (bl) {
                this.getVarlong();
                continue;
            }
            this.getString();
        }
    }

    private void cacheEventTypes() {
        this.executionSample = this.getTypeId("jdk.ExecutionSample");
        this.nativeMethodSample = this.getTypeId("jdk.NativeMethodSample");
        this.allocationInNewTLAB = this.getTypeId("jdk.ObjectAllocationInNewTLAB");
        this.allocationOutsideTLAB = this.getTypeId("jdk.ObjectAllocationOutsideTLAB");
        this.allocationSample = this.getTypeId("jdk.ObjectAllocationSample");
        this.monitorEnter = this.getTypeId("jdk.JavaMonitorEnter");
        this.threadPark = this.getTypeId("jdk.ThreadPark");
    }

    private int getTypeId(String string) {
        JfrClass jfrClass = this.typesByName.get(string);
        return jfrClass != null ? jfrClass.id : -1;
    }

    private int getVarint() {
        int n = 0;
        int n2 = 0;
        while (true) {
            byte by = this.buf.get();
            n |= (by & 0x7F) << n2;
            if (by >= 0) {
                return n;
            }
            n2 += 7;
        }
    }

    private long getVarlong() {
        long l = 0L;
        for (int i = 0; i < 56; i += 7) {
            byte by = this.buf.get();
            l |= ((long)by & 0x7FL) << i;
            if (by < 0) continue;
            return l;
        }
        return l | ((long)this.buf.get() & 0xFFL) << 56;
    }

    private String getString() {
        switch (this.buf.get()) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: {
                return new String(this.getBytes(), StandardCharsets.UTF_8);
            }
            case 4: {
                char[] cArray = new char[this.getVarint()];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)this.getVarint();
                }
                return new String(cArray);
            }
            case 5: {
                return new String(this.getBytes(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("Invalid string encoding");
    }

    private byte[] getBytes() {
        byte[] byArray = new byte[this.getVarint()];
        this.buf.get(byArray);
        return byArray;
    }

    private void seek(long l) throws IOException {
        this.filePosition = l;
        this.ch.position(l);
        this.buf.rewind().flip();
    }

    private boolean ensureBytes(int n) throws IOException {
        if (this.buf.remaining() >= n) {
            return true;
        }
        this.filePosition += (long)this.buf.position();
        if (this.buf.capacity() < n) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            byteBuffer.put(this.buf);
            this.buf = byteBuffer;
        } else {
            this.buf.compact();
        }
        while (this.ch.read(this.buf) > 0 && this.buf.position() < n) {
        }
        this.buf.flip();
        return this.buf.limit() > 0;
    }
}

