# URL Shortener assignment

## Setting
- Given that URL Shortener is a full-stack application, I'm presented with vast amount of tech choices — platform, frontend framework, storage solution, etc.
- For last ~18 months I'm mostly focused on Java development and have no production-grade Node.js and TypeScript experience.
- Considering the small-ish scope of the application I decided to use **Blitz.js** for the implementation. This decision allowed to scaffold a lot of code that I would otherwise have to write by myself.

## How to run the app

Working app instance is already available at [us.devg.ru](https://us.devg.ru).

This is a DigitalOcean server, running both the app and postgres database.

In order to run the app yourself, proceed with these steps in an app directory:

```bash
yarn # install dependencies
yarn dev # run local app instance

# In order to change database, alter the postgres connection sql in a .env file
# (currently pointing at DigitalOcean server).
# Alternatively, replace "postgres" with "sqlte" in schema.prisma,
# and remove "db/migrations" and run following commands:

yarn blitz prisma migrate dev
yarn dev # should be restarted to generate prisma clients

```

## Assumptions

### Short URL deactivation

Original spec mentions
> Button for deleting the link

yet for me real 'deletion' looks unwise, restricting us from checking link stats if it is deleted apart from other possible cases.

I had implemented revertible deactivation instead, allowing user to deactivate or activate a link when required.

This approach preserves the ability to analyse stats even if link is not active anymore.

### User accounts

Real URL shorteners store shortened URLs by users, allowing different users to create their own short links to same external URLs with unique personal ids.

Implementing the URL Shortener app without any form of user authorization would leave us with some possible problems in the future: reworking data model, adding validations to restrict users from accessing each other data, etc.

Thus, I've used auth implementation from Blitz.js. It's pretty basic, generates a lot of boilerplate code and is incomplete (e.g. requires mailer to send 'forgot password' emails) yet it allows for easy `userId` provision from the very start.

## Shortcomings

- The visual design is really basic, mostly due to my limited sense of beauty.
- Provided database is not hosted in a cloud and is not really scalable, yet this could be easily fixed as the app uses `prisma` that allows using DB engines.
- Test coverage leaves A LOT to be desired, only the short url ID generation is tested.

## Time spent

> we would like you to use few hours to create an URL shorterner application for us.

In fact, I had used more than 10 hours to achieve the result, and yet I'm really satisfied with it.

## Next steps

As already mentioned, project currently lacks tests and it should be fixed. I'd start with mutations tests, maybe some integration tests that also verify `prisma` queries.

Visuals could also be improved: better forms and error messages, more subtle elements and accents, etc.
