import { LabeledTextField } from "app/core/components/LabeledTextField/LabeledTextField";
import { Form, FORM_ERROR } from "app/core/components/Form/Form";
import signup from "app/auth/mutations/signup";
import { Signup } from "app/auth/validations";
import { useMutation } from "@blitzjs/rpc";
import Header from "app/components/Header/Header";

type SignupFormProps = {
  onSuccess?: () => void;
};

export const SignupForm = (props: SignupFormProps) => {
  const [signupMutation] = useMutation(signup);
  return (
    <div>
      <Header>Create an Account</Header>

      <Form
        submitText="Create Account"
        schema={Signup}
        initialValues={{ email: "", password: "" }}
        onSubmit={async (values) => {
          try {
            await signupMutation(values);
            props.onSuccess?.();
          } catch (error: any) {
            if (error.code === "P2002" && error.meta?.target?.includes("email")) {
              // This error comes from Prisma
              return { email: "This email is already being used" };
            } else {
              return { [FORM_ERROR]: error.toString() };
            }
          }
        }}
      >
        <LabeledTextField name="email" label="Email" placeholder="Email" />
        <LabeledTextField name="password" label="Password" placeholder="Password" type="password" />
      </Form>
    </div>
  );
};

export default SignupForm;
