import { paginate } from "blitz";
import { resolver } from "@blitzjs/rpc";
import db, { Prisma } from "db";

interface GetHitCountersInput
  extends Pick<Prisma.HitCounterFindManyArgs, "where" | "orderBy" | "skip" | "take"> {}

export default resolver.pipe(
  resolver.authorize(),
  async ({ where, orderBy, skip = 0, take = 250 }: GetHitCountersInput) => {
    const {
      items: hitCounters,
      hasMore,
      nextPage,
      count,
    } = await paginate({
      skip,
      take,
      count: () => db.hitCounter.count({ where }),
      query: (paginateArgs) => db.hitCounter.findMany({ ...paginateArgs, where, orderBy }),
    });

    return {
      hitCounters,
      nextPage,
      hasMore,
      count,
    };
  }
);
