import { NotFoundError } from "blitz";
import { resolver } from "@blitzjs/rpc";
import db from "db";
import { z } from "zod";

const RecordHit = z.object({
  id: z.string().length(6),
});

export default resolver.pipe(
  resolver.zod(RecordHit),
  async ({ id }) => {
    const date = new Date().toISOString().slice(0, 10);
    const shortUrl = await db.hitCounter.upsert({
      where: { shortUrlId_date: { shortUrlId: id, date } },
      update: { count: { increment: 1 } },
      create: { date, shortUrlId: id, count: 1 },
    });

    if (!shortUrl) throw new NotFoundError();

    return shortUrl;
  }
);
