import { Form, FormProps } from "app/core/components/Form/Form";
import { z } from "zod";
import TextField from "app/core/components/TextField/TextField"
export { FORM_ERROR } from "app/core/components/Form/Form";

export function ShortUrlForm<S extends z.ZodType<any, any>>(props: FormProps<S>) {
  return (
    <Form<S> {...props} submitText="Shorten">
      <TextField name="url" placeholder="Enter URL to shorten" />
    </Form>
  );
}
