import { useMutation } from "@blitzjs/rpc";
import activateShortUrl from "app/short-urls/mutations/activateShortUrl";
import deactivateShortUrl from "app/short-urls/mutations/deactivateShortUrl";
import styles from "./ShortUrlStatusToggle.module.css";

const ShortUrlStatusToggle = ({ shortUrl, refetch }) => {
  const [activateShortUrlMutation] = useMutation(activateShortUrl);
  const [deactivateShortUrlMutation] = useMutation(deactivateShortUrl);
  const { id, active } = shortUrl;
  return (
    <div className={styles.root}>
      {active ? (
        <button
          type="button"
          onClick={async () => {
            await deactivateShortUrlMutation({ id });
            await refetch();
          }}
        >
          Deactivate
        </button>
      ) : (
        <button
          type="button"
          onClick={async () => {
            await activateShortUrlMutation({ id });
            await refetch();
          }}
        >
          Activate
        </button>
      )}
    </div>
  );
};

export default ShortUrlStatusToggle;
