import generateUniqueShortUrlId from "./generateUniqueShortUrlId"

const LENGTH = 8;

const key = "1-https://google.com";
it("generates short id", async () => {
  const id = await generateUniqueShortUrlId(key, async () => false, LENGTH);
  expect(typeof id).toBe("string");
  expect(id).toHaveLength(LENGTH);
});

it("handle collisions short id", async () => {
  const maxCollisions = 10;
  const collisions: string[] = [];
  const id = await generateUniqueShortUrlId(key, async (id) => {
    if (collisions.length < maxCollisions) {
      expect(collisions.indexOf(id) === -1).toBeTruthy();
      collisions.push(id);
      return true;
    }
    return false;
  }, LENGTH);
  expect(id).toHaveLength(LENGTH);
});
