import crypto from "node:crypto";

const ID_LENGTH = 6;

const generateUniqueShortUrlId = async (
  key: string,
  checkIdIsUsed: (id: string) => Promise<boolean>,
  length: number = ID_LENGTH
): Promise<string> => {
  let salt = 0;
  let id;

  do {
    id = generateShortUrlId(`${salt}-${key}`, length);
    salt++;
  } while (await checkIdIsUsed(id));

  return id;
};

const generateShortUrlId = function (key, length) {
  const hash = crypto
    .createHash("md5")
    .update(key)
    .digest("base64")
    .replaceAll("/", "_")
    .replaceAll("+", "-");
  return hash.substring(0, length);
};

export default generateUniqueShortUrlId;
