import { resolver } from "@blitzjs/rpc";
import db from "db";
import { z } from "zod";

const ActivateShortUrl = z.object({
  id: z.string().length(6),
});

export default resolver.pipe(resolver.zod(ActivateShortUrl), resolver.authorize(), ({ id }) =>
  db.shortUrl.update({ where: { id }, data: { active: true } })
);
