import { resolver } from "@blitzjs/rpc";
import db from "db";
import { z } from "zod";

const DeactivateShortUrl = z.object({
  id: z.string().length(6),
});

export default resolver.pipe(resolver.zod(DeactivateShortUrl), resolver.authorize(), ({ id }) =>
  db.shortUrl.update({ where: { id }, data: { active: false } })
);
