import { NotFoundError } from "blitz";
import { resolver } from "@blitzjs/rpc";
import db from "db";
import { z } from "zod";

const GetShortUrl = z.object({
  id: z.string().length(6),
});

export default resolver.pipe(resolver.zod(GetShortUrl), async ({ id }) => {
  const shortUrl = await db.shortUrl.findFirst({ where: { id } });

  if (!shortUrl) throw new NotFoundError();

  return shortUrl;
});
