import { paginate, Ctx } from "blitz";
import { resolver } from "@blitzjs/rpc";
import db, { Prisma } from "db";

interface GetShortUrlsInput
  extends Pick<Prisma.ShortUrlFindManyArgs, "where" | "orderBy" | "skip" | "take"> {}

export default resolver.pipe(
  resolver.authorize(),
  async ({ where, orderBy, skip = 0, take = 100 }: GetShortUrlsInput, ctx: Ctx) => {
    const { userId } = ctx.session;
    if (userId != null) {
      if (where != undefined) {
        where.userId = userId;
      } else {
        where = { userId };
      }
    }
    const {
      items: shortUrls,
      hasMore,
      nextPage,
      count,
    } = await paginate({
      skip,
      take,
      count: () => db.shortUrl.count({ where }),
      query: (paginateArgs) => db.shortUrl.findMany({ ...paginateArgs, where, orderBy }),
    });

    return {
      shortUrls,
      nextPage,
      hasMore,
      count,
    };
  }
);
