import { ErrorFallbackProps, ErrorComponent, ErrorBoundary, AppProps, Routes } from "@blitzjs/next"
import { AuthenticationError, AuthorizationError } from "blitz";
import React from "react";
import { withBlitz } from "app/blitz-client";
import { useRouter } from "next/router"

function RootErrorFallback({ error }: ErrorFallbackProps) {
  const router = useRouter();

  if (error instanceof AuthenticationError) {
    router.push(Routes.WelcomePage()).catch((e) => console.error(e));
    return null;
  } else if (error instanceof AuthorizationError) {
    return (
      <ErrorComponent
        statusCode={error.statusCode}
        title="Sorry, you are not authorized to access this"
      />
    );
  } else {
    return (
      <ErrorComponent
        statusCode={(error as any)?.statusCode || 400}
        title={error.message || error.name}
      />
    );
  }
}

function MyApp({ Component, pageProps }: AppProps) {
  const getLayout = Component.getLayout || ((page) => page);
  return (
    <ErrorBoundary FallbackComponent={RootErrorFallback}>
      {getLayout(<Component {...pageProps} />)}
    </ErrorBoundary>
  );
}

export default withBlitz(MyApp);
