import { Suspense } from "react";
import { Routes } from "@blitzjs/next";
import { useRouter } from "next/router";
import { useCurrentUser } from "app/core/hooks/useCurrentUser";
import Layout from "app/core/layouts/Layout"
import Loading from "app/core/components/Loading/Loading"

const Redirect = () => {
  const router = useRouter();
  const currentUser = useCurrentUser();

  const page = currentUser ? Routes.ShortenPage() : Routes.WelcomePage();

  router.push(page).catch((e) => console.error(e));
  return null;
};

const HomePage = () => {
  return (
    <Layout title="URL Shortener">
      <Suspense fallback={<Loading />}>
        <Redirect />
      </Suspense>
    </Layout>
  );
};

export default HomePage;
