import { Suspense, useCallback, useState } from "react";
import Layout from "app/core/layouts/Layout";
import { useMutation } from "@blitzjs/rpc";
import createShortUrl from "app/short-urls/mutations/createShortUrl";
import { FORM_ERROR, ShortUrlForm } from "app/short-urls/components/ShortUrlForm";
import { CreateShortUrl } from "app/auth/validations";
import Header from "app/components/Header/Header";
import ShortUrlsSection from "app/short-urls/components/ShortUrlsSection/ShortUrlsSection";
import Loading from "app/core/components/Loading/Loading"

const NewShortUrlPage = () => {
  const [createShortUrlMutation] = useMutation(createShortUrl);
  const [lastShortUrlId, setLastShortUrlId] = useState("");
  const resetLastShortUrlId = useCallback(() => {
    setLastShortUrlId("");
  }, [setLastShortUrlId]);

  return (
    <Layout title="URL Shortener">
      <Header>URL Shortener</Header>

      <ShortUrlForm
        submitText="Create ShortUrl"
        onInput={resetLastShortUrlId}
        schema={CreateShortUrl}
        initialValues={{}}
        onSubmit={async (values) => {
          try {
            const shortUrl = await createShortUrlMutation(values);
            if (!shortUrl) {
              return {
                [FORM_ERROR]: "Something went wrong",
              };
            }
            const { id } = shortUrl;
            setLastShortUrlId(id);
          } catch (error: any) {
            return {
              [FORM_ERROR]: error.toString(),
            };
          }
        }}
      />

      <ShortUrlsSection lastShortUrlId={lastShortUrlId} />
    </Layout>
  );
};

const ShortenPage = () => {
  return (
    <Layout title="URL Shortener">
      <main>
        <Suspense fallback={<Loading />}>
          <NewShortUrlPage />
        </Suspense>
      </main>
    </Layout>
  );
};

ShortenPage.authenticate = true;

export default ShortenPage;
