import Layout from "app/core/layouts/Layout";
import { Routes } from "@blitzjs/next";
import Header from "app/components/Header/Header";
import WelcomeLinks from "app/welcome/components/WelcomeLinks/WelcomeLinks";
import WelcomeLink from "app/welcome/components/WelcomeLink/WelcomeLink";

const WelcomePage = () => (
  <Layout title="URL Shortener">
    <main>
      <Header>URL Shortener</Header>
      <WelcomeLinks>
        <WelcomeLink href={Routes.SignupPage()}>Sign Up</WelcomeLink>
        <WelcomeLink href={Routes.LoginPage()}>Login</WelcomeLink>
      </WelcomeLinks>
    </main>
  </Layout>
);

export default WelcomePage;
